# Stop whatever process is listening on port 5010 (Windows)
$port = 5010
$net = Get-NetTCPConnection -LocalPort $port -ErrorAction SilentlyContinue
if ($net) {
  $pids = $net | Select-Object -ExpandProperty OwningProcess -Unique
  foreach ($pid in $pids) {
    Write-Host "Killing PID $pid using port $port"
    Stop-Process -Id $pid -Force -ErrorAction SilentlyContinue
  }
  Write-Host "Stopped processes using port $port"
} else {
  Write-Host "No process found listening on port $port"
}
