package com.example.smshelper;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.util.Log;

public class SendActivity extends Activity {
    private static final String TAG = "SMS_HELPER";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Intent i = getIntent();
        String to = i.getStringExtra("to");
        String body = i.getStringExtra("body");

        if (to == null || body == null) {
            Log.e(TAG, "Missing 'to' or 'body' extras");
            finish();
            return;
        }

        try {
            SmsManager sms = SmsManager.getDefault();
            sms.sendTextMessage(to, null, body, null, null);
            Log.i(TAG, "SENT to=" + to + " body=" + body);
        } catch (Exception ex) {
            Log.e(TAG, "SEND_FAILED to=" + to + " err=" + ex.toString());
        }

        finish();
    }
}
