$ADB = $env:ADB_PATH
if (-not $ADB) { $ADB = 'C:\android\platform-tools\adb.exe' }

$APK = "$PSScriptRoot\sms-helper\app\build\outputs\apk\debug\app-debug.apk"

Write-Host "Using ADB: $ADB"
Write-Host "Looking for APK at: $APK"

if (-not (Test-Path $APK)) {
  Write-Error "APK not found at $APK. Build the project in Android Studio (open sms-helper) and re-run this script."
  exit 1
}

Write-Host "Installing APK..."
& $ADB install -r $APK
if ($LASTEXITCODE -ne 0) { Write-Error "adb install failed"; exit 2 }

Write-Host "Granting SEND_SMS permission..."
& $ADB shell pm grant com.example.smshelper android.permission.SEND_SMS

Write-Host "Starting helper activity to test..."
& $ADB shell am start -n com.example.smshelper/.SendActivity --es to "79079" --es body "TEST-HELPER"

Write-Host "Done. Check device and adb logcat for SMS_HELPER logs."
