SMS ADB Controller

Purpose
This small tool lets you queue SMS messages locally and send them through a connected Android device via adb (USB). It's intended for low-volume testing and reproducing successes/failures when placing SMS bets.

Warning
- Use only for local testing. Ensure you are allowed to send automated SMS to the recipient.
- Device must have USB debugging enabled and accept debugging keys.
- This approach is not as reliable as an SMS gateway.

Quick start
1. Install Node 16+ and Android platform-tools (adb) on your machine.
2. From this folder, run:
   npm install
   node server.js
3. Ensure your device is connected and visible:
   adb devices

Endpoints
- POST /send - enqueue an SMS and attempt to send immediately
  { "to": "+2547XXXXXXX", "body": "BET 1: ...", "meta": { "predictionId": "..." } }

- GET /queue - list queue items and statuses
- GET /logs - return recent logs
- POST /clear - clear the queue (dangerous)

How it works
- The server keeps a simple queue in memory and persists to queue.json on changes.
- The worker tries to send via adb by launching the SMS intent and simulating input keys.
- After sending, the worker checks the SMS Sent content provider for a matching record (best-effort).

Files
- server.js - Express server, queue and worker
- adbRunner.js - thin wrapper to run adb commands
- queue.json - persistent queue (created at runtime)
- logs.txt - runtime logs

Next steps / Improvements
- Use a real SMS gateway (Twilio/Africa's Talking) for production.
- Improve delivery confirmation by parsing carrier receipts or the provider's API.
- Add authentication to the server API.
