// Helper to enhance a prediction so selectionName and marketName are friendly for backend
function normalizeMarketName(m) {
  return String(m || '').trim().toLowerCase().replace(/\s+/g, '');
}

export function enhancePredictionWithFriendlyNames(prediction) {
  if (!prediction) return prediction;
  // Work on a deep clone to avoid mutating original
  let pred = JSON.parse(JSON.stringify(prediction));
  // If this is a lightweight preview, prefer the normalized/raw version
  if (pred._rawPrediction && typeof pred._rawPrediction === 'object') {
    pred = JSON.parse(JSON.stringify(pred._rawPrediction));
  }
  const games = Array.isArray(pred.selectedOdds) ? pred.selectedOdds : (pred.games || []);
  const compsRoot = Array.isArray(pred.competitors) ? pred.competitors : [];

  const enhanced = (games || []).map((g) => {
    const o = JSON.parse(JSON.stringify(g));
    // Normalize marketName '1X2' variants to '3 Way'
    if (o.marketName && normalizeMarketName(o.marketName) === '1x2') o.marketName = '3 Way';

    const sel = String(o.selectionName || '');
    const smsToken = sel.match(/^(\d+)#(\d+)$/);
    const comps = Array.isArray(o.competitors) && o.competitors.length ? o.competitors : (Array.isArray(pred.competitors) ? pred.competitors : compsRoot);
    if (smsToken) {
      const selId = smsToken[2];
      let matched = null;
      for (const c of comps || []) {
        if (!c) continue;
        if (String(c.id) === selId || String(c.selectionId) === selId || String(c.smsId) === selId || String(c.ID) === selId) { matched = c; break; }
      }
      if (matched && matched.name) o.selectionName = matched.name;
      else if (comps && comps.length >= 2) {
        if (selId === '1') o.selectionName = comps[0].name || 'Home';
        else if (selId === '2') o.selectionName = comps[1].name || 'Away';
        else o.selectionName = comps[0].name || 'Home';
      }
    } else {
      const normalizedSel = sel.trim().toUpperCase();
      if (['1','2','X'].includes(normalizedSel) && comps && comps.length >= 2) {
        if (normalizedSel === '1') o.selectionName = comps[0].name || o.selectionName;
        else if (normalizedSel === '2') o.selectionName = comps[1].name || o.selectionName;
        else o.selectionName = 'Draw';
      }
    }
    return o;
  });

  pred.selectedOdds = enhanced;
  return pred;
}

export default enhancePredictionWithFriendlyNames;
