import React from 'react';
import '../components/Navigation/Styles.css';
import '../components/Navigation/css';
import { AuthContext } from '../context/auth-context';

class RegisterPage extends React.Component {
  static contextType = AuthContext;

  constructor(props) {
    super(props);
    this.emailEl = React.createRef();
    this.passwordEl = React.createRef();
    this.firstNameEl = React.createRef();
    this.lastNameEl = React.createRef();
  }

  registerHandler = async (event) => {
    event.preventDefault();
    const email = this.emailEl.current?.value || '';
    const password = this.passwordEl.current?.value || '';

    // Basic client-side validation
    const firstName = this.firstNameEl.current?.value || '';
    const lastName = this.lastNameEl.current?.value || '';

    if (!firstName || !lastName) {
      alert('First name and Last name are required.');
      return;
    }

    if (!email || !password) {
      alert('Email and password are required.');
      return;
    }
    if (password.length < 6) {
      alert('Password must be at least 6 characters long.');
      return;
    }
    const emailRe = /\S+@\S+\.\S+/;
    if (!emailRe.test(email)) {
      alert('Please enter a valid email address.');
      return;
    }

    try {
      const res = await fetch('http://localhost:5000/api/register', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ email, password, firstName, lastName }),
      });

      // Try parse JSON body if present
      let data = null;
      try {
        const ct = res.headers.get('content-type') || '';
        if (ct.includes('application/json')) data = await res.json();
      } catch (parseErr) {
        // ignore parse error
      }

      if (!res.ok) {
        const msg = (data && (data.error || data.message)) || `Server returned ${res.status}`;
        console.error('Registration failed:', res.status, msg, data);
        alert('Registration failed: ' + msg);
        return;
      }

      alert('Registration successful! Logging you in...');
      // If server returned a customToken, use it to sign in immediately.
      if (data && data.customToken) {
        try {
          // Lazy import firebase auth signInWithCustomToken
          const { signInWithCustomToken } = await import('firebase/auth');
          await signInWithCustomToken((await import('../firebase')).auth, data.customToken);
          // token refresh/onAuthStateChanged will pick up user and redirect
          window.location.href = '/home';
          return;
        } catch (e) {
          console.warn('Auto sign-in with custom token failed', e);
        }
      }

      window.location.href = '/login';
    } catch (err) {
      console.error('Error during registration:', err);
      alert('Registration failed. Please try again.');
    }
  };

  render() {
    return (
      <div>
        <aside id="notifications">
          <div className="container">
            <link
              rel="stylesheet"
              href="./Contact us_files/css"
              type="text/css"
              media="all"
            />
            <link
              rel="stylesheet"
              href="./Contact us_files/theme-18c77515.css"
              type="text/css"
              media="all"
            />
          </div>
        </aside>
        <div className="breadcrumb_container " data-depth={1}>
          <div className="container">
            <nav data-depth={1} className="breadcrumb">
              <ol itemScope itemType="http://schema.org/BreadcrumbList">
                <li
                  itemProp="itemListElement"
                  itemScope
                  itemType="http://schema.org/ListItem"
                >
                  <a
                    itemProp="item"
                    href="file:///D:/E-Commerce/Frontend/Noola/demo.posthemes.com/pos_ecolife_digital/digital3/en/index.html"
                  >
                    <span itemProp="name">Home</span>
                  </a>
                  <meta itemProp="position" content={1} />
                </li>
              </ol>
            </nav>
          </div>
        </div>
        <div id="wrapper">
          <div className="container">
            <div className="row">
              <div id="content-wrapper" className="col-xs-12">
                <section id="main">
                  <header className="page-header">
                    <h1>Create a new account</h1>
                  </header>
                  <section id="content" className="page-content card card-block">
                    <section className="login-form">
                      <form id="register-form" onSubmit={this.registerHandler}>
                        <section>
                          <div className="form-group row ">
                            <label className="col-md-3 form-control-label required">First name</label>
                            <div className="col-md-6">
                              <input className="form-control" name="firstName" type="text" placeholder="First name" ref={this.firstNameEl} />
                            </div>
                          </div>

                          <div className="form-group row ">
                            <label className="col-md-3 form-control-label required">Last name</label>
                            <div className="col-md-6">
                              <input className="form-control" name="lastName" type="text" placeholder="Last name" ref={this.lastNameEl} />
                            </div>
                          </div>

                          <div className="form-group row ">
                            <label className="col-md-3 form-control-label required">Email</label>
                            <div className="col-md-6">
                              <input className="form-control" name="email" type="email" placeholder="your@email.com" ref={this.emailEl} />
                            </div>
                            <div className="col-md-3 form-control-comment"></div>
                          </div>

                          <div className="form-group row ">
                            <label className="col-md-3 form-control-label required">Password</label>
                            <div className="col-md-6">
                              <div className="input-group js-parent-focus">
                                <input className="form-control js-child-focus js-visible-password" name="password" type="password" placeholder="Enter Password" id="password" ref={this.passwordEl} />
                                <span className="input-group-btn">
                                  <button className="btn" type="button" data-action="show-password" data-text-show="Show" data-text-hide="Hide">Show</button>
                                </span>
                              </div>
                            </div>
                            <div className="col-md-3 form-control-comment"></div>
                          </div>
                        </section>
                        <footer className="form-footer text-sm-center clearfix">
                          <button
                            id="submit"
                            className="btn btn-primary"
                            data-link-action="sign-up"
                            type="submit"
                          >
                            Register
                          </button>
                        </footer>
                      </form>
                    </section>
                    <hr />
                    <div className="no-account">
                      <a
                        href="/login"
                        data-link-action="display-login-form"
                      >
                        Already have an account? Log in here
                      </a>
                    </div>
                  </section>
                  <footer className="page-footer"></footer>
                </section>
              </div>
            </div>
          </div>
        </div>
      </div>
    );
  }
}

export default RegisterPage;