import React from 'react';
import '../components/Navigation/Styles.css';
import '../components/Navigation/css';
import { AuthContext } from '../context/auth-context';
// import { NavLink } from 'react-router-dom';
import './Events.css';
import EventList from '../components/Events/EventList/EventList';
// import Profile from './ProfileImage';


  




class productUpload extends React.Component  {  
  
  state = {
    creating: true,
    products: []
    
  };

  static contextType = AuthContext;

  constructor(props) {
    super(props);
    this.productNameEl = React.createRef();
    this.productPriceEl = React.createRef();
    this.productCategoryEl = React.createRef();
    this.productBrandEl = React.createRef();
    this.countInStockEl = React.createRef();
    this.productImageEl = React.createRef();
    this.productDescriptionEl = React.createRef();
    this.ratingEl = React.createRef();
    this.productDateEl = React.createRef();  
    this.productnumReviewsEl = React.createRef();
    }

  componentDidMount() {
    this.fetchEvents();
  }
  

  showDetailHandler = productId => {
    this.setState(prevState => {
      const selectedEvent = prevState.products.find(e => e._id === productId);
      return { selectedEvent: selectedEvent };
    });
  };
  

  submitHandler = event => {
    event.preventDefault()
    console.log("inafika hapa");
    this.setState({ creating: false });
    const name = this.productNameEl.current.value;
    const price = +this.productPriceEl.current.value;
    const category = this.productCategoryEl.current.value;
    const brand = this.productBrandEl.current.value;
    const image = this.productImageEl.current.value;
    const countinstock = +this.countInStockEl.current.value;
    const description = this.productDescriptionEl.current.value;
    const rating = +this.ratingEl.current.value;
    const date = this.productDateEl.current.value;
    const numreviews = +this.productnumReviewsEl.current.value;
  
    if (name.trim().length === 0 || 
        price <= 0 || 
        rating <= 0 || 
        numreviews <= 0|| category.trim().length === 0 || 
        brand.trim().length === 0 || 
        image.trim().length === 0 || 
        countinstock <= 0 || 
        description.trim().length === 0 || 
        date.trim().length === 0)  {
      return;
    }
  
    const product = { name, price, category, brand, image, countinstock, description, rating, numreviews, date };
      console.log(product);

      const requestBody = {
        query: `
          mutation CreateProduct($name: String!, $price: Float!, $numreviews: Float!, $category: String!, $brand: String!, $image: String!, $countinstock: Float!, $description: String! $rating: Float!, $date: String!) {
            createProduct(productInput: {name: $name, price: $price, category: $category, brand: $brand, image: $image, countInStock: $countinstock, numReviews: $numreviews, description: $description, rating: $rating, date: $date}) {
              _id
            name
            price
            category
            brand
            image
            countInStock
            description
            }
          }
        `,
        variables: {
          name: name,
          price: price,
          category: category,
          brand: brand,
          image: image,
          countinstock: countinstock,
          description: description,
          rating: rating,
          date: date,
          numreviews: numreviews
        }
      };
      const token = this.context.token;

      fetch('http://localhost:3080/graphql', {
        method: 'POST',
        body: JSON.stringify(requestBody),
        headers: {
          'Content-Type': 'application/json',
          Authorization: 'Bearer ' + token  
        }
      })
        .then(res => {
          if (res.status !== 200 && res.status !== 201) {
            throw new Error('Failed!');
          }
          return res.json();
        })
        .then(resData => {
          this.fetchEvents();
        })
      .catch(err => {
        console.log(err);
      });
  };
  fetchEvents() {
    const requestBody = {
      query: `
          query {
            products {
              _id
              name
              description
              date
              price
              creator {
                _id
                email
              }
            }
          }
        `
    };


    
    fetch('http://localhost:3080/graphql', {
      method: 'POST',
      body: JSON.stringify(requestBody),
      headers: {
        'Content-Type': 'application/json'
      }
    })
      .then(res => {
        if (res.status !== 200 && res.status !== 201) {
          throw new Error('Failed!');
        }
        return res.json();
      })
      .then(resData => {
        const products = resData.data.products;
        this.setState({ products: products });
      })
      .catch(err => {
        console.log(err);
       
      });
  }
  

   render() {
    
      
    
      return (                              
        <React.Fragment>
          {this.state.creating && <div>
  <div id="wrapper">
    <div className="container">
      <div className="row">
        <div id="left-column" className="col-xs-12 col-sm-4 col-md-3">
          <div className="contact-rich">
            <h4>Product information</h4>
            <div className="block">
              <div className="icon"><i className="material-icons"></i></div>
              <div className="data">Noola Accessories Store<br />East Africa</div>
            </div>
            <hr />
            <div className="block">
              <div className="icon"><i className="material-icons"></i></div>
              <div className="data">
                Call us:<br />
                <a href="tel:(+254)719616550">(+254)719 616550</a>
              </div>
            </div>
            <hr />
            <div className="block">
              <div className="icon"><i className="material-icons"></i></div>
              <div className="data email">
                Email us:<br />
              </div>
              {/* mailto:customercare@noola.co.ke */}
              <a href="mailto:customercare@noola.co.ke">customercare@noola.com</a>
            </div>
          </div>
        </div>
        <div id="content-wrapper" className="left-column col-xs-12 col-sm-8 col-md-9">
          <section id="main">
            <section id="content" className="page-content card card-block">
              <section className="contact-form">
                <form id="product-upload-form" onSubmit={this.submitHandler} >
                  <section className="form-fields">
                    <div className="form-group row">
                      <div className="col-md-9 col-md-offset-3">
                        <h3>Upload Details</h3>
                      </div>
                    </div>
                    <div className="form-group row">
                      <label className="col-md-3 form-control-label" htmlFor="category">Category</label>
                      <div className="col-md-6">
                      
                      {/* <input className="form-control" name="category" type="text" ref={this.productCategoryEl} placeholder="Product Category" /> */}
                      
                            
                            <select className="form-control form-control-select" value={this.state.value} onChange={this.handleChange} name="id_contact" ref={this.productCategoryEl} >
                              
                              <option value="no_category">-- Select A Category --</option>
                              <option value="laptops">Laptops</option>
                              <option value="phones">Phones</option>
                              <option value="drones">Drones</option>
                              <option value="desktops">Desktops</option>
                              <option value="printers">Printers</option>
                              <option value="accesories">Accesories</option>
                              <option value="cameras">Cameras</option>
                            </select>
                      </div>
                    </div>
                    <div className="form-group row">
                      <label className="col-md-3 form-control-label"htmlFor="name">Product Name</label>
                      <div className="col-md-6">
                        <input className="form-control" name="name" type="text" ref={this.productNameEl} placeholder="Name of Product" />
                      </div>
                      </div>           

                      <div className="form-group row">
                      <label className="col-md-3 form-control-label"htmlFor="price">Price</label>
                      <div className="col-md-6">
                        <input className="form-control" name="price" type="number" id="price" ref={this.productPriceEl}  placeholder="Product Price" />
                      </div>
              
                    </div>
                    <div className="form-group row">
                      <label className="col-md-3 form-control-label" htmlFor="brand">Brand</label>
                      <div className="col-md-6">
                      <input className="form-control" name="brand" type="text" ref={this.productBrandEl} placeholder="Product Brand" />
                                              {/* <select name="id_contact" ref={this.productBrandElRef} value={this.state.value2} onChange={this.handleChange2} className="form-control form-control-select">
                        <option value="no_brand">-- Select A Brand --</option>
                              <option value="helwett_packard">Helwett Packard</option>
                              <option value="asus">ASUS</option>
                              <option value="dell">Dell</option>
                              <option value="acer">Acer</option>
                              <option value="razor_blade">Razor BLade</option>
                              <option value="compaq">Compaq</option>
                              <option value="lenovo">Lenovo</option>                                                
                        </select> */}
                      </div>
                    </div>
                    <div className="form-group row">
                      <label className="col-md-3 form-control-label"htmlFor="countInStock">Count In Stock</label>
                      <div className="col-md-6">
                        <input className="form-control" name="countinstock" type="number" id="countInStock"  ref={this.countInStockEl} placeholder="Product Quantity in Stock" />
                      </div>
                      </div>
                    <div className="form-group row">
                      <label className="col-md-3 form-control-label" htmlFor="image">Attachment</label>
                      <div className="col-md-6">
                        {/* <input type="file" name="fileUpload" ref={this.productImageEl} className="filestyle" data-buttontext="Choose file"  id="filestyle-0" tabIndex={-1} style={{position: 'absolute', clip: 'rect(0px, 0px, 0px, 0px)'}} /><div required onChange={upload} value={__filename} ref={this.productImageEl}  className="bootstrap-filestyle input-group"><input type="text" className="form-control "  /> <span className="group-span-filestyle input-group-btn" tabIndex={0}><label htmlFor="filestyle-0" className="btn btn-default "><span className="icon-span-filestyle glyphicon glyphicon-folder-open" /> <span className="buttonText">Choose file</span></label></span></div> */}
                        {/* <Profile/> */}
                        <input className="form-control" name="image" type="text" ref={this.productImageEl} placeholder="Product Image" />
                     
                      </div>
                      <span className="col-md-3 form-control-comment">
                        (Optional)
                      </span>
                    </div>
                    <div className="form-group row">
                      <label className="col-md-3 form-control-label"htmlFor="description">Description</label>
                      <div className="col-md-9">
                        <textarea className="form-control" name="description" ref={this.productDescriptionEl} placeholder="Product Description" rows={3} defaultValue={""} />
                      </div>
                    </div>
                   
                    <div className="form-group row">
                      <label className="col-md-3 form-control-label" htmlFor="date">Date</label>
                      <div className="col-md-6">
                        <input type="datetime-local" name="date" id="date" ref={this.productDateEl} className="form-control" />
                        {/* <input className="form-control" name="date" type="text" ref={this.productDateEl} placeholder="Product Image" /> */}
                     
                      </div>
                      </div> 

                     <div className="form-group row">
                      <label className="col-md-3 form-control-label" htmlFor="rating">Rating</label>
                      <div className="col-md-6">
                        <input className="form-control" type="number" name="rating" id="rating" ref={this.ratingEl} placeholder="Product Rating" />
                      </div>
                      </div>
                      <div className="form-group row">
                      <label className="col-md-3 form-control-label" htmlFor="numreviews">Num Review</label>
                      <div className="col-md-6">
                        <input className="form-control" type="number"name="numreviews" id="numreviews" ref={this.productnumReviewsEl} placeholder="Product Rating" />
                      </div>
                      </div>

                    <div className="form-group row">
                      <div className="offset-md-3">
                      </div>
                    </div>
                  </section>
                  <footer className="form-footer text-sm-right">        
                  {/* required onChange={upload} */}
                                    
                    
                  {/* <NavLink to='/homeproducts'> */}
                    <button id="submit" className="btn btn-primary"  onClick={this.submitHandler} data-link-action="sign-in" type="submit">
                     Upload Product 
                          </button> 
                          {/* </NavLink> */}
                  </footer>
                </form>
                
              </section>
            </section>
          </section></div></div></div>
          
</div></div>}
          <div>
            <div>
          <h1>{this.state.name}</h1>
            <h2>
              ${this.state.price} -{' '}
              {new Date(this.state.date).toLocaleDateString()}
            </h2>
            <p>{this.state.description}</p>

            </div>
          <EventList
            products={this.state.products}
            authUserId={this.context.userId}
            onViewDetail={this.showDetailHandler}
          />

            
</div>

</React.Fragment>
      );

      }
    }
    
  

export default productUpload;
