import React, { useState } from 'react';
import axios from 'axios';

const PaymentPage = () => {
  const [phoneNumber, setPhoneNumber] = useState('');
  const [amount, setAmount] = useState('');
  const [loading, setLoading] = useState(false);
  const [message, setMessage] = useState('');

  const handlePayment = async () => {
    setLoading(true);
    setMessage('');

    try {
      await axios.post('http://localhost:5000/api/mpesaPayment', {
        phoneNumber,
        amount,
        accountReference: '123456', // Example account reference
        transactionDesc: 'Payment for Prediction', // Example transaction description
      });

      setMessage('Payment initiated successfully. Please complete the payment on your phone.');
    } catch (error) {
      console.error('Error initiating payment:', error);
      setMessage('Error initiating payment. Please try again.');
    } finally {
      setLoading(false);
    }
  };

  return (
    <div style={styles.container}>
      <div style={styles.paymentBox}>
        <h2 style={styles.header}>Payment Information</h2>
        <div style={styles.section}>
          <h3 style={styles.subHeader}>Select Payment Method</h3>
          <div style={styles.radioGroup}>
            <label style={styles.radioLabel}>
              <input type="radio" name="paymentMethod" value="mpesa" defaultChecked />
              Mpesa
            </label>
            <label style={styles.radioLabel}>
              <input type="radio" name="paymentMethod" value="paypal" />
              PayPal
            </label>
          </div>
        </div>

        <div style={styles.section}>
          <h3 style={styles.subHeader}>Personal Information</h3>
          <div style={styles.inputGroup}>
            <label style={styles.label}>
              Phone Number:
              <input
                type="text"
                value={phoneNumber}
                onChange={(e) => setPhoneNumber(e.target.value)}
                placeholder="Enter your phone number"
                style={styles.input}
              />
            </label>
            <label style={styles.label}>
              Amount:
              <input
                type="text"
                value={amount}
                onChange={(e) => setAmount(e.target.value)}
                placeholder="Enter amount"
                style={styles.input}
              />
            </label>
          </div>
        </div>

        <button onClick={handlePayment} disabled={loading} style={styles.button}>
          {loading ? 'Processing...' : 'Complete Payment'}
        </button>
        {message && <p style={styles.message}>{message}</p>}
      </div>

      <div style={styles.cartBox}>
        <h3 style={styles.cartHeader}>Checkout Cart</h3>
        <p>Total: <strong>Ksh {amount || '0.00'}</strong></p>
        <p style={styles.cartNote}>Please confirm your payment details before proceeding.</p>
      </div>
    </div>
  );
};

const styles = {
  container: {
    display: 'flex',
    justifyContent: 'space-between',
    padding: '20px',
    fontFamily: 'Arial, sans-serif',
  },
  paymentBox: {
    flex: 2,
    padding: '20px',
    border: '1px solid #ccc',
    borderRadius: '8px',
    backgroundColor: '#fff',
    marginRight: '20px',
  },
  header: {
    fontSize: '24px',
    marginBottom: '20px',
    textAlign: 'center',
  },
  section: {
    marginBottom: '20px',
  },
  subHeader: {
    fontSize: '18px',
    marginBottom: '10px',
  },
  radioGroup: {
    display: 'flex',
    gap: '10px',
  },
  radioLabel: {
    fontSize: '16px',
  },
  inputGroup: {
    display: 'flex',
    flexDirection: 'column',
    gap: '10px',
  },
  label: {
    fontSize: '16px',
    marginBottom: '5px',
  },
  input: {
    width: '100%',
    padding: '10px',
    fontSize: '16px',
    border: '1px solid #ccc',
    borderRadius: '4px',
  },
  button: {
    width: '100%',
    padding: '10px',
    fontSize: '16px',
    backgroundColor: '#007BFF',
    color: '#fff',
    border: 'none',
    borderRadius: '4px',
    cursor: 'pointer',
  },
  message: {
    marginTop: '10px',
    fontSize: '14px',
    color: 'green',
    textAlign: 'center',
  },
  cartBox: {
    flex: 1,
    padding: '20px',
    border: '1px solid #ccc',
    borderRadius: '8px',
    backgroundColor: '#f9f9f9',
  },
  cartHeader: {
    fontSize: '20px',
    marginBottom: '10px',
  },
  cartNote: {
    fontSize: '14px',
    color: '#555',
  },
};

export default PaymentPage;