import React from 'react';
import { useRepeatedOdds } from '../hooks/useRepeatedOdds';

// This section displays repeated odds in the Betlist page (without listing predictions)
const BetlistRepeatedOddsSection = () => {
  const { data, loading, error } = useRepeatedOdds();

  if (loading) return <div>Loading repeated odds...</div>;
  if (error) return <div style={{ color: 'red' }}>Error loading repeated odds: {error.message || String(error)}</div>;
  if (!data || Object.keys(data).length === 0) return null;

  return (
    <div style={{ marginBottom: 24 }}>
      <h3>Repeated Odds</h3>
      <table style={{ width: '100%', borderCollapse: 'collapse' }}>
        <thead>
          <tr>
            <th style={{ border: '1px solid #ccc', padding: 4 }}>Game</th>
            <th style={{ border: '1px solid #ccc', padding: 4 }}>Market</th>
            <th style={{ border: '1px solid #ccc', padding: 4 }}>Selection</th>
            <th style={{ border: '1px solid #ccc', padding: 4 }}>Odds</th>
            <th style={{ border: '1px solid #ccc', padding: 4 }}>Date</th>
            <th style={{ border: '1px solid #ccc', padding: 4 }}>Repeated Count</th>
          </tr>
        </thead>
        <tbody>
          {Object.values(data).flat().map((item, idx) => {
            const { odd, repeatedInPredictions } = item;
            return (
              <tr key={odd.gameId + odd.marketName + odd.selectionName + idx}>
                <td style={{ border: '1px solid #ccc', padding: 4 }}>
                  {odd.competitors && odd.competitors.map(c => c.name).join(' vs ')}
                </td>
                <td style={{ border: '1px solid #ccc', padding: 4 }}>{odd.marketName}</td>
                <td style={{ border: '1px solid #ccc', padding: 4 }}>{odd.selectionName}</td>
                <td style={{ border: '1px solid #ccc', padding: 4 }}>{odd.odds}</td>
                <td style={{ border: '1px solid #ccc', padding: 4 }}>{new Date(odd.Date).toLocaleString()}</td>
                <td style={{ border: '1px solid #ccc', padding: 4 }}>
                  {repeatedInPredictions.length}
                </td>
              </tr>
            );
          })}
        </tbody>
      </table>
    </div>
  );
};

export default BetlistRepeatedOddsSection;
