import React, { useState, useEffect } from 'react';
import { onAuthStateChanged } from 'firebase/auth';
import { getIdTokenResult } from 'firebase/auth';
import { auth } from '../firebase';

export const AuthContext = React.createContext({
	user: null,
	token: null,
	login: async () => {},
	logout: () => {},
});

export function AuthProvider({ children }) {
	const [user, setUser] = useState(null);
	const [token, setToken] = useState(null);
	const [role, setRole] = useState(null);

	useEffect(() => {
		const unsub = onAuthStateChanged(auth, async (u) => {
			if (u) {
				setUser(u);
				const t = await u.getIdToken();
				setToken(t);
				try {
					const idResult = await getIdTokenResult(u);
					const claims = idResult.claims || {};
					setRole(claims.role || null);
				} catch (e) {
					console.warn('Failed to read token claims', e);
					setRole(null);
				}
			} else {
				setUser(null);
				setToken(null);
				setRole(null);
			}
		});
		return () => unsub();
	}, []);

	const login = (u, t) => {
		setUser(u);
		setToken(t);
	};

	const logout = async () => {
		try {
			await auth.signOut();
		} catch (e) {
			console.warn('Sign out failed', e);
		}
		setUser(null);
		setToken(null);
	};

	 return (
	 		<AuthContext.Provider value={{ user, token, role, login, logout }}>
	 			{children}
	 		</AuthContext.Provider>
	 	);
}