import React from 'react';
import './SpinnerModal.css';

const SpinnerModal = ({ open, title, message }) => {
  if (!open) return null;
  return (
    <div className="sm-backdrop">
      <div className="sm-modal">
        <div className="sm-spinner" />
        <div className="sm-content">
          <div className="sm-title">{title || 'Please wait'}</div>
          <div className="sm-message">{message || 'Waiting for device confirmation...'}</div>
        </div>
      </div>
    </div>
  );
};

export default SpinnerModal;
