import React from 'react';

export default function RepeatedOdds({ data, loading, error }) {
  if (loading) return <div>Loading repeated odds...</div>;
  if (error) return <div>Error loading repeated odds: {error.message}</div>;
  if (!data || Object.keys(data).length === 0) return <div>No repeated odds found.</div>;

  return (
    <div>
      <h2>Repeated Selected Odds</h2>
      {Object.entries(data).map(([gameId, oddsArr]) => (
        <div key={gameId} style={{ marginBottom: 24 }}>
          <h3>Game ID: {gameId}</h3>
          <table border="1" cellPadding="6" style={{ width: '100%', borderCollapse: 'collapse' }}>
            <thead>
              <tr>
                <th>Market</th>
                <th>Selection</th>
                <th>Odds</th>
                <th>Repeated In Predictions</th>
              </tr>
            </thead>
            <tbody>
              {oddsArr.map(({ odd, repeatedInPredictions }, idx) => (
                <tr key={idx}>
                  <td>{odd.market || '-'}</td>
                  <td>{odd.selection || '-'}</td>
                  <td>{odd.odds || '-'}</td>
                  <td>{repeatedInPredictions.join(', ')}</td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      ))}
    </div>
  );
}
