import React, { useState, useContext } from 'react';
import { useLocation } from 'react-router-dom';
import Invoice from './Invoice';
import ProductReceipt from './ProductReceipt/ProductReceipt';
import { AuthContext } from '../context/auth-context';
import { useEffect } from 'react';
import { CONTROL_BASE } from '../config/smsAdbConfig';

const PredictionDetails = () => {
  const location = useLocation();
  const state = location.state;
  const prediction = state && state.prediction;
  const fromPayment = state && state.fromPayment;
  const showInvoice = state && state.showInvoice;

  const [copied, setCopied] = useState(false);
  const [copiedAt, setCopiedAt] = useState(null);

  const handleSmsCopied = () => {
    setCopied(true);
    setCopiedAt(new Date());
    // optional: clear the banner after 4 seconds
    setTimeout(() => setCopied(false), 4000);
  };

  const { user } = useContext(AuthContext);
  const [liveEvents, setLiveEvents] = useState([]);

  useEffect(() => {
    // subscribe to local sms-adb SSE events
    let es;
    try {
  es = new EventSource(`${CONTROL_BASE}/events`);
      es.onmessage = (e) => {
        setLiveEvents(prev => [e.data].concat(prev).slice(0, 50));
      };
      es.addEventListener('queue:update', (ev) => {
        setLiveEvents(prev => [`queue:update ${ev.data}`].concat(prev).slice(0, 50));
      });
      es.addEventListener('inbox:match', (ev) => {
        setLiveEvents(prev => [`inbox:match ${ev.data}`].concat(prev).slice(0, 50));
      });
    } catch (e) {
      // ignore if EventSource not available
    }
    return () => { if (es) es.close(); };
  }, []);

  // Determine customer from stored profile (saved at login), then AuthContext, then fallback hardcoded
  let customer = null;
  try {
    const raw = localStorage.getItem('user_profile');
    if (raw) {
      const parsed = JSON.parse(raw);
      if (parsed.expiresAt && Date.now() < parsed.expiresAt && parsed.profile) {
        customer = { name: parsed.profile.displayName || (user?.displayName || ''), contact: parsed.profile.contact || (user?.email || '') };
      } else {
        // expired
        localStorage.removeItem('user_profile');
      }
    }
  } catch (e) {
    // ignore
  }
  if (!customer) {
    if (user) customer = { name: user.displayName || (user.email || '').split('@')[0], contact: user.email || '' };
    else customer = { name: 'Eddison Peter Maina', contact: 'customer@example.com' };
  }

  if (!prediction) {
    return <p>No prediction details available.</p>;
  }

  // Determine if this is a product or prediction
  // Products have: productId, image, category, brand
  // Predictions have: selectedOdds with detailed game info
  const isProduct = prediction.productId || (prediction.category && prediction.brand);

  return (
    <div>
      {/* Show success message when coming from successful payment */}
      {fromPayment && showInvoice && (
        <div style={{
          marginBottom: 20,
          padding: 15,
          background: '#e6ffed',
          border: '2px solid #2ecc71',
          borderRadius: 6,
          color: '#055a20',
          fontSize: '1.05rem',
          fontWeight: '500'
        }}>
          ✓ Payment successful! Your invoice is below.
        </div>
      )}

      {/* Show appropriate invoice/receipt based on content type */}
      {isProduct ? (
        <ProductReceipt 
          product={prediction} 
          customer={customer}
          paymentReference={state?.paymentReference}
        />
      ) : (
        <>
          {/* pass the handler to Invoice and set stake=1 (1 bob) so server and UI match */}
          <Invoice prediction={prediction} customer={customer} onSmsCopied={handleSmsCopied} stake={1} />

          {copied && (
            <div style={{
              marginTop: 12,
              padding: 10,
              background: '#e6ffed',
              border: '1px solid #2ecc71',
              borderRadius: 4,
              color: '#055a20'
            }}>
              Bet placed — SMS copied to clipboard{copiedAt ? ` at ${copiedAt.toLocaleTimeString()}` : ''}.
            </div>
          )}

          {/* Live events from local sms controller */}
          <div style={{ marginTop: 12 }}>
            <h4>Local SMS controller events</h4>
            <div style={{ maxHeight: 160, overflow: 'auto', background: '#f7f7f7', padding: 8, borderRadius: 4, border: '1px solid #ddd' }}>
              {liveEvents.length === 0 ? <div style={{ color: '#666' }}>No recent events.</div> : liveEvents.map((l, i) => <div key={i} style={{ fontSize: '0.9rem', padding: '2px 0' }}>{l}</div>)}
            </div>
          </div>
        </>
      )}
    </div>
  );
};

export default PredictionDetails;