import React from 'react';
import './Prediction.css'; // Import the new CSS file
import PredictionItem from './Events/EventList/EventItem/predictionItem';

const Prediction = ({ predictions, onBuyClick }) => {
  if (!predictions || predictions.length === 0) {
    return (
      <div className="betslip-card-container">
        <h2>No predictions available at the moment.</h2>
      </div>
    );
  }

  return (
    <div className="prediction-grid-container"> {/* render each prediction using the per-card component that includes payment UI */}
      {predictions.map((prediction, index) => (
        <PredictionItem
          key={prediction.predictionId || `prediction-${index}`}
          predictionId={prediction.predictionId || `prediction-${index}`}
          predictionName={prediction.predictionName || `Prediction ${index + 1}`}
          predictiontype={prediction.predictiontype || 'Prediction'}
          numGames={prediction.numGames || (prediction.selectedOdds && prediction.selectedOdds.length) || 0}
          totalOdds={prediction.totalOdds || 1}
          selectedOdds={prediction.selectedOdds || []}
          price={prediction.price || 100}
        />
      ))}
    </div>
  );
};

export default Prediction;