import React from 'react';
import './21l5OKCEfWL._RC_71kMVn_b8a8.css';
import { NavLink } from 'react-router-dom';
// import AuthContext from '../../context/auth-context';
import Logo from './img/predict-logo.png';
// import { NavLink } from 'react-router-dom';
import { AuthContext } from '../../context/auth-context';

// Small child component that encapsulates auth-related hooks and UI.
const AuthArea = () => {
  const context = React.useContext(AuthContext);
  const user = context && context.user;
  const logout = context && context.logout;
  const name = user ? (user.displayName || (user.email ? user.email.split('@')[0] : '')) : null;
  const greeting = name ? `${name}` : 'Account';

  // Hooks must be called unconditionally
  const [open, setOpen] = React.useState(false);
  const wrapperRef = React.useRef(null);
  React.useEffect(() => {
    function handleClickOutside(event) {
      if (wrapperRef.current && !wrapperRef.current.contains(event.target)) {
        setOpen(false);
      }
    }
    document.addEventListener('mousedown', handleClickOutside);
    return () => document.removeEventListener('mousedown', handleClickOutside);
  }, []);

  if (user) {
    return (
      <div ref={wrapperRef} style={{ position: 'relative' }}>
        <button onClick={() => setOpen(s => !s)} className="nav-a nav-a-2" id="nav-link-accountList" tabIndex={22} style={{ background: 'transparent', border: 'none', cursor: 'pointer' }}>
          <div className="nav-line-1-container"><span className="nav-line-1">{greeting}</span></div>
          <span className="nav-line-2 nav-long-width">Account &amp; Lists<span className="nav-icon nav-arrow" style={{ visibility: 'visible' }} />
          </span>
        </button>
        {open && (
          <div style={{ position: 'absolute', right: 0, top: '100%', background: '#fff', border: '1px solid #ddd', boxShadow: '0 4px 12px rgba(0,0,0,0.08)', zIndex: 50, minWidth: 180 }}>
            <a href="/profile" className="nav-link" style={{ display: 'block', padding: '10px 12px' }} onClick={() => setOpen(false)}>Profile</a>
            <a href="/profile?tab=history" className="nav-link" style={{ display: 'block', padding: '10px 12px' }} onClick={() => setOpen(false)}>Prediction History</a>
            <button onClick={async () => { setOpen(false); if (logout) await logout(); }} style={{ display: 'block', padding: '10px 12px', width: '100%', textAlign: 'left', background: 'none', border: 'none', cursor: 'pointer' }}>Logout</button>
          </div>
        )}
      </div>
    );
  }

  return (
    <div style={{ display: 'flex', gap: 8, alignItems: 'center' }}>
      <a href="/login" className="btn btn-link">Login</a>
      <a href="/register" className="btn btn-primary">Sign up</a>
    </div>
  );
};

const AdminLink = () => {
  const context = React.useContext(AuthContext);
  if (context && context.role === 'superuser') return (<a href="/admin" className="nav-a nav-a-2">Admin</a>);
  return null;
};

// Search component for team search functionality with autocomplete
const TeamSearchForm = () => {
  const [searchTerm, setSearchTerm] = React.useState('');
  const [searchCategory, setSearchCategory] = React.useState('teams');
  const [suggestions, setSuggestions] = React.useState([]);
  const [showSuggestions, setShowSuggestions] = React.useState(false);
  const [selectedIndex, setSelectedIndex] = React.useState(-1);
  const searchRef = React.useRef(null);
  const dropdownRef = React.useRef(null);

  // Instant fallback teams data for immediate autocomplete responsiveness
  const [teamsData, setTeamsData] = React.useState([
    'Arsenal', 'Barcelona', 'Manchester United', 'Liverpool', 'Chelsea', 'Real Madrid',
    'Manchester City', 'Tottenham', 'Bayern Munich', 'Paris Saint-Germain', 'Juventus',
    'AC Milan', 'Inter Milan', 'Atletico Madrid', 'Borussia Dortmund', 'Ajax',
    'Drogheda Utd', 'Shamrock Rovers', 'Bohemians', 'Dundalk FC', 'Cork City',
    'Leicester City', 'West Ham', 'Newcastle United', 'Brighton', 'Crystal Palace',
    'Everton', 'Aston Villa', 'Leeds United', 'Wolves', 'Southampton', 'Sochaux',
    'Real Betis', 'Valencia', 'Sevilla', 'Athletic Bilbao', 'Villarreal', 'Getafe',
    'Celta Vigo', 'Real Sociedad', 'Osasuna', 'Cadiz', 'Mallorca', 'Almeria',
    'Elche', 'Girona', 'Rayo Vallecano', 'Granada', 'Las Palmas', 'Alaves'
  ]);

  const [isLoadingRealTeams, setIsLoadingRealTeams] = React.useState(false);

  // Load teams from gameOddsService in background (non-blocking)
  React.useEffect(() => {
    const loadTeamsData = async () => {
      setIsLoadingRealTeams(true);
      try {
        // Import gameOddsService dynamically to avoid import issues in nav component
        const gameOddsService = await import('../../services/gameOddsService');
        
  // Get teams from current predictions/odds data (use cached getter to avoid forcing a fresh network load)
  const games = gameOddsService.default.getCachedGamesData();
        
        // Also try to get comprehensive game data from alternative endpoints
        let allGameDataTeams = [];
        
        // Try multiple endpoints for comprehensive data
        const comprehensiveEndpoints = [
          'http://localhost:5000/api/admin/gameOdds',  // Comprehensive game odds
          'http://localhost:5000/api/allGameData',     // All game data (may fail)
          'http://localhost:5000/api/getData'          // Alternative data source
        ];
        
        for (const endpoint of comprehensiveEndpoints) {
          try {
            console.log(`Trying comprehensive data from: ${endpoint}`);
            const response = await fetch(endpoint, {
              method: 'GET',
              headers: {
                'Content-Type': 'application/json',
                'Authorization': localStorage.getItem('token') ? `Bearer ${localStorage.getItem('token')}` : undefined
              }
            });
            
            if (response.ok) {
              const data = await response.json();
              console.log(`✅ Retrieved comprehensive data from ${endpoint}`);
              
              // Handle different data structures
              if (endpoint.includes('admin/gameOdds')) {
                // Handle admin/gameOdds structure
                if (data.data && data.data.games) {
                  data.data.games.forEach(game => {
                    if (game.Competitors && Array.isArray(game.Competitors)) {
                      game.Competitors.forEach(competitor => {
                        if (competitor.Name) {
                          allGameDataTeams.push(competitor.Name);
                        }
                      });
                    }
                  });
                }
              } else if (Array.isArray(data)) {
                // Handle array structure (allGameData)
                data.forEach(gameData => {
                  // Extract from competitors array
                  if (gameData.competitors && Array.isArray(gameData.competitors)) {
                    gameData.competitors.forEach(competitor => {
                      if (typeof competitor === 'string') {
                        allGameDataTeams.push(competitor);
                      } else if (competitor.name) {
                        allGameDataTeams.push(competitor.name);
                      }
                    });
                  }
                  
                  // Extract from marketData if available
                  if (gameData.marketData && gameData.marketData.games) {
                    gameData.marketData.games.forEach(game => {
                      if (game.competitors) {
                        game.competitors.forEach(comp => {
                          if (comp.name) {
                            allGameDataTeams.push(comp.name);
                          }
                        });
                      }
                    });
                  }
                });
              } else if (data && typeof data === 'object') {
                // Handle object structure
                Object.values(data).forEach(item => {
                  if (item && Array.isArray(item)) {
                    item.forEach(game => {
                      if (game.Competitors) {
                        game.Competitors.forEach(comp => {
                          if (comp.Name) {
                            allGameDataTeams.push(comp.Name);
                          }
                        });
                      }
                    });
                  }
                });
              }
              
              if (allGameDataTeams.length > 0) {
                console.log(`Found ${allGameDataTeams.length} teams from ${endpoint}`);
                break; // Stop trying other endpoints if we got data
              }
            } else {
              console.warn(`${endpoint} failed: HTTP ${response.status}`);
            }
          } catch (error) {
            console.warn(`Could not load data from ${endpoint}:`, error.message);
          }
        }
        
        // Extract unique team names from current games
        const teamSet = new Set();
        games.forEach(game => {
          if (game.Competitors && Array.isArray(game.Competitors)) {
            game.Competitors.forEach(competitor => {
              if (competitor.Name) {
                teamSet.add(competitor.Name);
              }
            });
          }
          // Also try homeTeam and awayTeam properties
          if (game.homeTeam) {
            teamSet.add(game.homeTeam);
          }
          if (game.awayTeam) {
            teamSet.add(game.awayTeam);
          }
        });
        
        const currentTeams = Array.from(teamSet);
        
        // Combine fallback teams, current teams, and comprehensive teams
        const allTeams = [...new Set([...teamsData, ...currentTeams, ...allGameDataTeams])].sort();
        setTeamsData(allTeams);
        
        console.log('✅ Enhanced teams loaded for autocomplete:', allTeams.length, 'teams');
        console.log('- Fallback teams:', teamsData.length);
        console.log('- Current game teams:', currentTeams.length);
        console.log('- Comprehensive teams:', allGameDataTeams.length);
        console.log('Sample enhanced teams:', allTeams.slice(0, 10));
      } catch (error) {
        console.warn('⚠️ Could not load enhanced teams from service, using fallback list:', error);
      } finally {
        setIsLoadingRealTeams(false);
      }
    };

    // Delay loading to not block initial render
    const timeoutId = setTimeout(loadTeamsData, 100);
    return () => clearTimeout(timeoutId);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // Function to filter teams based on input
  const getFilteredSuggestions = (input) => {
    if (!input || input.length < 1) return [];
    
    const filtered = teamsData.filter(team =>
      team.toLowerCase().includes(input.toLowerCase())
    );
    
    return filtered.slice(0, 7); // Limit to 7 suggestions
  };

  // Handle input change
  const handleInputChange = (e) => {
    const value = e.target.value;
    setSearchTerm(value);
    
    if (value.length >= 1) {
      const filtered = getFilteredSuggestions(value);
      setSuggestions(filtered);
      setShowSuggestions(filtered.length > 0);
      setSelectedIndex(-1);
    } else {
      setSuggestions([]);
      setShowSuggestions(false);
    }
  };

  // Handle keyboard navigation
  const handleKeyDown = (e) => {
    if (!showSuggestions) return;

    switch (e.key) {
      case 'ArrowDown':
        e.preventDefault();
        setSelectedIndex(prev => 
          prev < suggestions.length - 1 ? prev + 1 : prev
        );
        break;
      case 'ArrowUp':
        e.preventDefault();
        setSelectedIndex(prev => prev > 0 ? prev - 1 : -1);
        break;
      case 'Enter':
        e.preventDefault();
        if (selectedIndex >= 0 && suggestions[selectedIndex]) {
          selectSuggestion(suggestions[selectedIndex]);
        } else if (searchTerm.trim()) {
          handleSearch(e);
        }
        break;
      case 'Escape':
        setShowSuggestions(false);
        setSelectedIndex(-1);
        break;
      default:
        break;
    }
  };

  // Select a suggestion
  const selectSuggestion = (team) => {
    setSearchTerm(team);
    setShowSuggestions(false);
    setSelectedIndex(-1);
    
    // Auto-search when team is selected
    setTimeout(() => {
      const adminUrl = `/adminpanel?search=${encodeURIComponent(team)}&section=gameodds`;
      window.location.href = adminUrl;
    }, 100);
  };

  // Handle form submission
  const handleSearch = (e) => {
    e.preventDefault();
    
    if (!searchTerm.trim()) {
      alert('Please enter a search term');
      return;
    }
    
    const trimmedSearch = searchTerm.trim();
    setShowSuggestions(false);
    
    // Redirect to admin panel with search parameters
    if (searchCategory === 'teams') {
      const adminUrl = `/adminpanel?search=${encodeURIComponent(trimmedSearch)}&section=gameodds`;
      window.location.href = adminUrl;
    } else if (searchCategory === 'leagues') {
      const adminUrl = `/adminpanel?search=${encodeURIComponent(trimmedSearch)}&section=gameodds&type=league`;
      window.location.href = adminUrl;
    } else {
      const searchUrl = `/search?q=${encodeURIComponent(trimmedSearch)}&category=${searchCategory}`;
      window.location.href = searchUrl;
    }
    
    setSearchTerm('');
  };

  // Handle clicks outside to close dropdown
  React.useEffect(() => {
    const handleClickOutside = (event) => {
      if (dropdownRef.current && !dropdownRef.current.contains(event.target) &&
          searchRef.current && !searchRef.current.contains(event.target)) {
        setShowSuggestions(false);
        setSelectedIndex(-1);
      }
    };

    document.addEventListener('mousedown', handleClickOutside);
    return () => document.removeEventListener('mousedown', handleClickOutside);
  }, []);

  return (
    <div style={{ position: 'relative', width: '100%' }}>
      <form acceptCharset="utf-8" className="nav-searchbar" onSubmit={handleSearch} role="search">
        <div className="nav-left">
          <div id="nav-search-dropdown-card">
            <div className="nav-search-scope nav-sprite">
              <div className="nav-search-facade" data-value={`search-alias=${searchCategory}`}>
                <span className="nav-search-label" style={{ width: 'auto' }}>
                  {searchCategory === 'teams' ? 'Teams' : 'All'}
                </span>
                <i className="nav-icon" />
              </div>
              <span id="searchDropdownDescription" style={{ display: 'none' }}>Select what you want to search for</span>
              <select 
                aria-describedby="searchDropdownDescription" 
                className="nav-search-dropdown searchSelect" 
                value={`search-alias=${searchCategory}`}
                onChange={(e) => setSearchCategory(e.target.value.replace('search-alias=', ''))}
                style={{ display: 'block', top: '2.5px' }} 
                tabIndex={18} 
                title="Search in"
              >
                <option value="search-alias=teams">Teams & Competitors</option>
                <option value="search-alias=leagues">Leagues</option>
                <option value="search-alias=all">All Predictions</option>
              </select>
            </div>
          </div>
        </div>
        <div className="nav-right">
          <div className="nav-search-submit nav-sprite">
            <span id="nav-search-submit-text" className="nav-search-submit-text nav-sprite">
              Go
            </span>
            <input type="submit" className="nav-input" value="Go" tabIndex={20} />
          </div>
        </div>
        <div className="nav-fill">
          <div className="nav-search-field" style={{ position: 'relative' }}>
            <label id="nav-search-label" htmlFor="team-search-input" className="aok-offscreen">
              Search Teams
            </label>
            <input 
              ref={searchRef}
              type="text" 
              id="team-search-input" 
              name="field-keywords" 
              autoComplete="off" 
              placeholder={
                searchCategory === 'teams' ? 
                  `Search teams (e.g., Arsenal, Drogheda Utd...)${isLoadingRealTeams ? ' • Loading more...' : ''}` : 
                searchCategory === 'leagues' ? 'Search leagues (e.g., Premier League...)' : 
                'Search all predictions...'
              } 
              className="nav-input" 
              dir="auto" 
              tabIndex={19}
              value={searchTerm}
              onChange={handleInputChange}
              onKeyDown={handleKeyDown}
              onFocus={() => {
                if (suggestions.length > 0) {
                  setShowSuggestions(true);
                }
              }}
            />
            
            {/* Autocomplete Dropdown */}
            {showSuggestions && suggestions.length > 0 && (
              <div 
                ref={dropdownRef}
                style={{
                  position: 'absolute',
                  top: '100%',
                  left: 0,
                  right: 0,
                  background: '#fff',
                  border: '1px solid #ddd',
                  borderTop: 'none',
                  boxShadow: '0 4px 12px rgba(0,0,0,0.1)',
                  zIndex: 1000,
                  maxHeight: '300px',
                  overflowY: 'auto'
                }}
              >
                {suggestions.map((team, index) => (
                  <div
                    key={team}
                    onClick={() => selectSuggestion(team)}
                    onMouseEnter={() => setSelectedIndex(index)}
                    style={{
                      padding: '12px 16px',
                      cursor: 'pointer',
                      backgroundColor: selectedIndex === index ? '#f0f0f0' : '#fff',
                      borderBottom: index < suggestions.length - 1 ? '1px solid #eee' : 'none',
                      fontSize: '14px',
                      fontFamily: 'Arial, sans-serif'
                    }}
                  >
                    <div style={{ fontWeight: '500', color: '#333' }}>
                      {team}
                    </div>
                    <div style={{ fontSize: '12px', color: '#666', marginTop: '2px' }}>
                      Search for {team} matches
                    </div>
                  </div>
                ))}
              </div>
            )}
          </div>
          <div id="nav-iss-attach" />
        </div>
      </form>
    </div>
  );
};


const mainNavigation = props => (



    
        <div>
          <div id="navbar" cel_widget_id="Navigation-desktop-navbar" data-template="layoutSwapToolBar" role="navigation" className="nav-sprite-v1 celwidget nav-bluebeacon nav-a11y-t1 layout2 nav-packard-glow hamburger bold-focus-hover using-mouse" data-csa-c-id="uy3dn4-vcnqpx-l1p8yz-ydum4h">
            <div id="nav-belt">
              <div className="nav-left">
                  <button type="button" id="nav-hamburger-menu" tabIndex={5} aria-label="Open Menu" className="nav-a nav-hamburger" style={{ background: 'transparent', border: 'none', padding: 0 }}>
                    <i className="hm-icon nav-sprite" />
                  </button>
                <div id="nav-logo">
                  <NavLink to="/home" className="nav-logo-link" aria-label="Home" tabIndex={6}>
                    <img src={Logo} alt="Predict AI" className="nav-logo-image" />
                    <span className="nav-sprite nav-logo-base" />
                    <span className="nav-sprite nav-logo-ext" />
                    <span className="nav-logo-locale" />
                  </NavLink>
                </div>
              </div>
              <div className="nav-right">
                <div id="nav-tools" className="layoutToolbarPadding">
                  <button type="button" id="icp-nav-flyout" className="nav-a nav-a-2 icp-link-style-2" style={{ background: 'transparent', border: 'none' }}>
                    <span className="icp-nav-link-inner">
                      <span className="nav-line-1">
                        <span className="icp-nav-flag icp-nav-flag-us" />
                      </span>
                      <span className="nav-line-2">&nbsp;
                        <span className="nav-icon nav-arrow" style={{ visibility: 'visible' }} />
                      </span>
                    </span>
                  </button>
                  <AuthArea />
                  <AdminLink />
                  <button type="button" className="nav-a nav-a-2  " id="nav-orders" tabIndex={24} style={{ background: 'transparent', border: 'none' }}>
                    <span className="nav-line-1">Returns</span>
                    <span className="nav-line-2">&amp; Orders</span>
                  </button>
                  <button type="button" aria-label="0 items in cart" className="nav-a nav-a-2" id="nav-cart" tabIndex={26} style={{ background: 'transparent', border: 'none' }}>
                    <span aria-hidden="true" className="nav-line-1" />
                    <span aria-hidden="true" className="nav-line-2">Cart<span className="nav-icon nav-arrow" />
                    </span>
                    <span className="nav-cart-icon nav-sprite" />
                    <span id="nav-cart-count" aria-hidden="true" className="nav-cart-count nav-cart-0">0</span>
                  </button>
                </div>
              </div>
              <div className="nav-fill">
                <div id="nav-search">
                  <div id="nav-bar-left" />
                  <TeamSearchForm />
                </div>
              </div>
              <div id="nav-flyout-anchor">
                <div id="nav-flyout-prime" className="nav-coreFlyout nav-flyout">
                  <div className="nav-arrow">
                    <div className="nav-arrow-inner" />
                  </div>
                  <div className="nav-template nav-flyout-content nav-spinner" />
                </div>
                <div id="nav-flyout-accountList" className="nav-coreFlyout nav-flyout">
                  <div className="nav-arrow">
                    <div className="nav-arrow-inner" />
                  </div>
                  <div className="nav-template nav-flyout-content">
                    <div id="nav-al-container">
                      <div id="nav-al-signin">
                        <div id="nav-flyout-ya-signin" className="nav-flyout-content nav-flyout-accessibility">
                          <a href="/" rel="nofollow" className="nav-action-button" data-nav-role="signin" data-nav-ref="nav_signin">
                            <span className="nav-action-inner">Sign in</span>
                          </a>
                          <div id="nav-flyout-ya-newCust" className="nav_pop_new_cust nav-flyout-content nav-flyout-accessibility">New customer? <a href="/" rel="nofollow" className="nav-a">Start here.</a>
                          </div>
                        </div>
                      </div>
                      <div id="nav-al-wishlist" className="nav-al-column nav-tpl-itemList nav-flyout-accessibility">
                        <div className="nav-title" id="nav-al-title">Your Lists</div><a href="/" className="nav-link nav-item"><span className="nav-text">Create a List</span></a> <a href="/" className="nav-link nav-item"><span className="nav-text">Find a List or Registry</span></a> <a href="/" className="nav-link nav-item"><span className="nav-text">Find a Gift</span></a> <a href="/" className="nav-link nav-item"><span className="nav-text">Save Items from the Web</span></a> <a href="/" className="nav-link nav-item"><span className="nav-text">Wedding Registry</span></a> <a href="/" className="nav-link nav-item"><span className="nav-text">Baby Registry</span></a> <a href="/" className="nav-link nav-item"><span className="nav-text">Friends &amp; Family Gifting</span></a> <a href="file:///D:/gp/clpf?ref_=nav_ListFlyout_smi_se_ya_lll_ll" className="nav-link nav-item"><span className="nav-text">AmazonSmile Charity Lists</span></a> <a href="file:///D:/gp/pantry/yourlists?ref_=nav_ListFlyout_pntry_gno" className="nav-link nav-item"><span className="nav-text">Pantry Lists</span></a> <a href="file:///D:/ideas/saves?ref_=nav_ListFlyout_strm_in_youtique_lists" className="nav-link nav-item"><span className="nav-text">Your Hearts</span></a> <a href="file:///D:/ideas?ref_=nav_ListFlyout_idea_nav" className="nav-link nav-item"><span className="nav-text">Explore Idea Lists</span></a> <a href="file:///D:/showroom?ref_=nav_ListFlyout_srm_your_desk_wl" className="nav-link nav-item"><span className="nav-text">Explore Showroom</span></a> <a href="file:///D:/stylequiz/?ref_=nav_ListFlyout_sq_ya_yl" className="nav-link nav-item"><span className="nav-text">Take the Home Style Quiz</span></a></div><div id="nav-al-your-account" className="nav-al-column nav-template nav-flyout-content nav-tpl-itemList nav-flyout-accessibility"><div className="nav-title">Your Account</div><a href="file:///D:/gp/css/homepage.html?ref_=nav_AccountFlyout_ya" className="nav-link nav-item"><span className="nav-text">Your Account</span></a> <a id="nav_prefetch_yourorders" href="file:///D:/gp/css/order-history?ref_=nav_AccountFlyout_orders" className="nav-link nav-item"><span className="nav-text">Your Orders</span></a>
                        <a href="file:///D:/gp/yourstore?ref_=nav_AccountFlyout_recs" className="nav-link nav-item">
                          <span className="nav-text">Your Recommendations</span></a>
                        <a href="file:///D:/gp/subscribe-and-save/manager/viewsubscriptions?ref_=nav_AccountFlyout_sns" className="nav-link nav-item"><span className="nav-text">Your Subscribe &amp; Save Items</span></a> <a href="file:///D:/yourmembershipsandsubscriptions?ref_=nav_AccountFlyout_digital_subscriptions" className="nav-link nav-item"><span className="nav-text">Memberships &amp; Subscriptions</span></a> <a href="file:///D:/localservices/ya/servicerequests?ref_=nav_AccountFlyout_desktop_vas_requestlist" className="nav-link nav-item"><span className="nav-text">Your Service Requests</span></a> <a href="file:///D:/gp/your-garage/?ref_=nav_AccountFlyout_au_pf_as_GNO" className="nav-link nav-item"><span className="nav-text">Your Garage</span></a> <a href="file:///D:/fanshop?ref_=nav_AccountFlyout_yfs" className="nav-link nav-item"><span className="nav-text">Your Fanshop</span></a> <a href="file:///D:/yourpets?ref_=nav_AccountFlyout_pet_profiles" className="nav-link nav-item"><span className="nav-text">Your Pets</span></a> <a href="file:///D:/hz/mycd/myx?ref_=nav_AccountFlyout_myk" className="nav-link nav-item"><span className="nav-text">Your Content and Devices</span></a> <a href="file:///D:/gp/dmusic/mp3/player?ref_=nav_AccountFlyout_cldplyr" className="nav-link nav-item"><span className="nav-text">Your Music Library</span></a> <a href="file:///D:/clouddrive?ref_=nav_AccountFlyout_clddrv" className="nav-link nav-item"><span className="nav-text">Your Amazon Drive</span></a> <a href="file:///D:/Prime-Instant-Video/s/browse?node=2676882011&ref_=nav_AccountFlyout_piv" className="nav-link nav-item"><span className="nav-text">Your Prime Video</span></a> <a href="file:///D:/gp/kindle/ku/ku_central?ref_=nav_AccountFlyout_ku" className="nav-link nav-item"><span className="nav-text">Your Kindle Unlimited</span></a> <a href="file:///D:/gp/video/watchlist?ref_=nav_AccountFlyout_ywl" className="nav-link nav-item"><span className="nav-text">Your Watchlist</span></a> <a href="file:///D:/gp/video/library?ref_=nav_AccountFlyout_yvl" className="nav-link nav-item"><span className="nav-text">Your Video Purchases &amp; Rentals</span></a> 
                        <a href="file:///D:/gp/mas/your-account/myapps?ref_=nav_AccountFlyout_aad" className="nav-link nav-item"><span className="nav-text">Your Android Apps &amp; Devices</span></a></div></div></div></div><div id="nav-flyout-abAcquisition" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div>
                  <div className="nav-template nav-flyout-content nav-spinner" />
                </div><div id="nav-flyout-abActivation" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-groceries" className="nav-coreFlyout nav-flyout">
                  <div className="nav-arrow"><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-transientFlyout" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-fresh" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div>
                  <div className="nav-template nav-flyout-content nav-spinner" />
                </div>
                <div className="nav-signin-tt nav-flyout" style={{ display: 'none', position: 'absolute', top: '-4px', left: '1027.83px', opacity: 1 }}><div className="nav-arrow"><div className="nav-arrow-inner" /></div>
                  <div id="nav-signin-tooltip"><a href="/" className="nav-action-button" data-nav-role="signin" data-nav-ref="nav_custrec_signin"><span className="nav-action-inner">Sign in</span></a><div className="nav-signin-tooltip-footer">New customer? <a href="/" className="nav-a">Start here.</a></div></div></div><div id="nav-flyout-icp" className="nav-coreFlyout nav-flyout" style={{ display: 'none', position: 'absolute', top: '-5px', left: '675.047px' }}>
                  <div className="nav-arrow" style={{ position: 'absolute', left: 27 }}>
                    <div className="nav-arrow-inner" />
                  </div><div className="nav-template nav-flyout-content nav-spinner" /></div>
                <div id="nav-flyout-icp-footer-flyout" className="nav-coreFlyout nav-flyout">
                  <div className="nav-arrow"><div className="nav-arrow-inner" />
                  </div><div className="nav-template nav-flyout-content nav-spinner" /></div></div><div id="nav-flyout-iss-anchor"><div id="nav-flyout-searchAjax" className="nav-issFlyout nav-flyout"><div className="nav-template nav-flyout-content" />
                  </div></div><div id="nav-flyout-anchor"><div id="nav-flyout-prime" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-accountList" className="nav-coreFlyout nav-flyout" style={{ display: 'none', position: 'absolute', top: '-5px', left: '787.828px' }}><div className="nav-arrow" style={{ position: 'absolute', left: '359.234px' }}><div className="nav-arrow-inner" /></div>
                    <div className="nav-template nav-flyout-content"><div id="nav-al-container"><div id="nav-al-signin">
                      <div id="nav-flyout-ya-signin" className="nav-flyout-content nav-flyout-accessibility"><a href="/" rel="nofollow" className="nav-action-button" data-nav-role="signin" data-nav-ref="nav_signin"><span className="nav-action-inner">Sign in</span></a><div id="nav-flyout-ya-newCust" className="nav_pop_new_cust nav-flyout-content nav-flyout-accessibility">New customer? <a href="/" rel="nofollow" className="nav-a">Start here.</a>
                      </div>
                      </div>
                    </div>
                      <div id="nav-al-wishlist" className="nav-al-column nav-tpl-itemList nav-flyout-accessibility">
                        <div className="nav-title" id="nav-al-title">Your Lists</div><a href="/gp/registry/wishlist?triggerElementID=createList&ref_=nav_ListFlyout_create" className="nav-link nav-item"><span className="nav-text">Create a List</span></a> <a href="/gp/registry/search?ref_=nav_ListFlyout_find" className="nav-link nav-item"><span className="nav-text">Find a List or Registry</span></a> <a href="/gcx/Gifts-for-Everyone/gfhz/?_encoding=UTF8&ref_=nav_wishlist_gf" className="nav-link nav-item"><span className="nav-text">Find a Gift</span></a> <a href="/gp/BIT?bitCampaignCode=a0032&ref_=nav_ListFlyout_bit_v2_a0032" className="nav-link nav-item"><span className="nav-text">Save Items from the Web</span></a> <a href="/wedding/home?ref_=nav_ListFlyout_wr" className="nav-link nav-item"><span className="nav-text">Wedding Registry</span></a> <a href="/baby-reg/homepage?ref_=nav_ListFlyout_br" className="nav-link nav-item"><span className="nav-text">Baby Registry</span></a> <a href="/gcx/-/gfhz/connections/list?ref_=nav_ListFlyout_fafgift" className="nav-link nav-item"><span className="nav-text">Friends &amp; Family Gifting</span></a> <a href="/gp/clpf?ref_=nav_ListFlyout_smi_se_ya_lll_ll" className="nav-link nav-item"><span className="nav-text">AmazonSmile Charity Lists</span></a> <a href="/gp/pantry/yourlists?ref_=nav_ListFlyout_pntry_gno" className="nav-link nav-item"><span className="nav-text">Pantry Lists</span></a> <a href="/ideas/saves?ref_=nav_ListFlyout_strm_in_youtique_lists" className="nav-link nav-item"><span className="nav-text">Your Hearts</span></a>
                        <a href="/ideas?ref_=nav_ListFlyout_idea_nav" className="nav-link nav-item"><span className="nav-text">Explore Idea Lists</span></a> <a href="/showroom?ref_=nav_ListFlyout_srm_your_desk_wl" className="nav-link nav-item"><span className="nav-text">Explore Showroom</span></a> <a href="/stylequiz/?ref_=nav_ListFlyout_sq_ya_yl" className="nav-link nav-item"><span className="nav-text">Take the Home Style Quiz</span></a></div><div id="nav-al-your-account" className="nav-al-column nav-template nav-flyout-content nav-tpl-itemList nav-flyout-accessibility"><div className="nav-title">Your Account</div><a href="/gp/css/homepage.html?ref_=nav_AccountFlyout_ya" className="nav-link nav-item"><span className="nav-text">Your Account</span></a> <a id="nav_prefetch_yourorders" href="/gp/css/order-history?ref_=nav_AccountFlyout_orders" className="nav-link nav-item"><span className="nav-text">Your Orders</span></a> <a href="/gp/yourstore?ref_=nav_AccountFlyout_recs" className="nav-link nav-item"><span className="nav-text">Your Recommendations</span></a> <a href="/gp/subscribe-and-save/manager/viewsubscriptions?ref_=nav_AccountFlyout_sns" className="nav-link nav-item"><span className="nav-text">Your Subscribe &amp; Save Items</span></a> <a href="/yourmembershipsandsubscriptions?ref_=nav_AccountFlyout_digital_subscriptions" className="nav-link nav-item">
                          <span className="nav-text">Memberships &amp; Subscriptions</span></a> <a href="/localservices/ya/servicerequests?ref_=nav_AccountFlyout_desktop_vas_requestlist" className="nav-link nav-item"><span className="nav-text">Your Service Requests</span></a> <a href="/gp/your-garage/?ref_=nav_AccountFlyout_au_pf_as_GNO" className="nav-link nav-item"><span className="nav-text">Your Garage</span></a> <a href="/fanshop?ref_=nav_AccountFlyout_yfs" className="nav-link nav-item"><span className="nav-text">Your Fanshop</span></a> <a href="/yourpets?ref_=nav_AccountFlyout_pet_profiles" className="nav-link nav-item"><span className="nav-text">Your Pets</span></a> <a href="/hz/mycd/myx?ref_=nav_AccountFlyout_myk" className="nav-link nav-item"><span className="nav-text">Your Content and Devices</span></a> <a href="/gp/dmusic/mp3/player?ref_=nav_AccountFlyout_cldplyr" className="nav-link nav-item"><span className="nav-text">Your Music Library</span></a> <a href="/clouddrive?ref_=nav_AccountFlyout_clddrv" className="nav-link nav-item"><span className="nav-text">Your Amazon Drive</span></a> <a href="/Prime-Instant-Video/s/browse?node=2676882011&ref_=nav_AccountFlyout_piv" className="nav-link nav-item">
                          <span className="nav-text">Your Prime Video</span></a> <a href="/gp/kindle/ku/ku_central?ref_=nav_AccountFlyout_ku" className="nav-link nav-item"><span className="nav-text">Your Kindle Unlimited</span></a> <a href="/gp/video/watchlist?ref_=nav_AccountFlyout_ywl" className="nav-link nav-item"><span className="nav-text">Your Watchlist</span></a> <a href="/gp/video/library?ref_=nav_AccountFlyout_yvl" className="nav-link nav-item"><span className="nav-text">Your Video Purchases &amp; Rentals</span></a> <a href="/gp/mas/your-account/myapps?ref_=nav_AccountFlyout_aad" className="nav-link nav-item"><span className="nav-text">Your Android Apps &amp; Devices</span></a></div></div></div></div><div id="nav-flyout-abAcquisition" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div>
                  <div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-abActivation" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-groceries" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-transientFlyout" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div>
                  <div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-fresh" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div><div className="nav-signin-tt nav-flyout" style={{ display: 'none', position: 'absolute', top: '-4px', left: '1027.83px', opacity: 1 }}>
                  <div className="nav-arrow"><div className="nav-arrow-inner" /></div><div id="nav-signin-tooltip"><a href="/gp/navigation/redirector.html/ref=sign-in-redirect?ie=UTF8&associationHandle=usflex&currentPageURL=file%3A%2F%2F%2FD%3A%2FNew%2520folder%2FAmazon.com_%2520Online%2520Shopping%2520for%2520Electronics%2C%2520Apparel%2C%2520Computers%2C%2520Books%2C%2520DVDs%2520%26%2520more.html%3Fref_%3Dnav_custrec_signin&pageType=Gateway&switchAccount=&yshURL=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fhome%3Fie%3DUTF8%26ref_%3Dnav_custrec_signin" className="nav-action-button" data-nav-role="signin" data-nav-ref="nav_custrec_signin"><span className="nav-action-inner">Sign in</span></a>
                    <div className="nav-signin-tooltip-footer">New customer? <a href="https://www.amazon.com/ap/register?_encoding=UTF8&openid.assoc_handle=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2Fhome%3Fie%3DUTF8%26ref_%3Dnav_custrec_newcust" className="nav-a">Start here.</a></div></div></div><div id="nav-flyout-icp" className="nav-coreFlyout nav-flyout" style={{ display: 'none', position: 'absolute', top: '-4px', left: '676.047px' }}><div className="nav-arrow" style={{ position: 'absolute', left: 26 }}><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div><div id="nav-flyout-icp-footer-flyout" className="nav-coreFlyout nav-flyout"><div className="nav-arrow"><div className="nav-arrow-inner" /></div><div className="nav-template nav-flyout-content nav-spinner" /></div></div><div id="nav-flyout-iss-anchor"><div id="nav-flyout-searchAjax" className="nav-issFlyout nav-flyout"><div className="nav-template nav-flyout-content" />
              // </div>
              </div>
            </div>
            <div id="nav-main" className="nav-sprite">
              <div className="nav-left">
                {/* NAVYAAN-GLOW-NAV */}
                <div id="nav-global-location-slot">
                  <span className="a-declarative" data-a-modal="{&quot;width&quot;:375, &quot;closeButton&quot;:&quot;false&quot;,&quot;popoverLabel&quot;:&quot;Choose your location&quot;, &quot;name&quot;:&quot;glow-modal&quot;, &quot;url&quot;:&quot;/gp/glow/get-address-selections.html?deviceType=desktop&pageType=Gateway&storeContext=NoStoreName&quot;, &quot;footer&quot;:&quot;<span class=\&quot;a-declarative\&quot; data-action=\&quot;a-popover-close\&quot; data-a-popover-close=\&quot;{}\&quot;><span class=\&quot;a-button a-button-primary\&quot;><span class=\&quot;a-button-inner\&quot;><button name=\&quot;glowDoneButton\&quot; class=\&quot;a-button-text\&quot; type=\&quot;button\&quot;>Done</button></span></span></span>&quot;,&quot;header&quot;:&quot;Choose your location&quot;}" data-action="a-modal">
                    <a href="www.noola.co.ke" className="nav-a nav-a-2 a-popover-trigger a-declarative" tabIndex={35}>
                      <div className="nav-sprite" id="nav-packard-glow-loc-icon" />
                      <div id="glow-ingress-block">
                        <span className="nav-line-1" id="glow-ingress-line1">
                          Premium Predictions
                        </span>
                        <span className="nav-line-2" id="glow-ingress-line2">
                          in Kenya
                        </span>
                      </div>
                    </a>
                  </span>
                  <input data-addnewaddress="add-new" id="unifiedLocation1ClickAddress" name="dropdown-selection" type="hidden" defaultValue="add-new" />
                  <input data-addnewaddress="add-new" id="ubbShipTo" name="dropdown-selection-ubb" type="hidden" defaultValue="add-new" />
                </div>
                {/* NAVYAAN-GLOW-NAV-TOASTER */}
              </div>
              <div className="nav-right">
                {/* Navyaan SWM */}
                <div id="nav-swmslot" className="nav-swm-text-widget">
                  <a href="https://blog.aboutamazon.com/company-news/amazons-actions-to-help-employees-communities-and-customers-affected-by-covid-19/?_encoding=UTF8&token=GW&utm_content=COVID-19_roundup&utm_medium=swm&utm_source=gateway&utm_term=gw03162020&ref_=nav_swm_undefined&pf_rd_p=74875fb1-f1e3-4e55-9ab0-26eaad2d4e3c&pf_rd_s=nav-sitewide-msg-text-export&pf_rd_t=4201&pf_rd_i=navbar-4201&pf_rd_m=ATVPDKIKX0DER&pf_rd_r=MEKH4ZE6Z1MM20NV6F4N" className="nav_a nav-swm-text" tabIndex={53}>Predict ai</a>
                </div>
              </div>
              <div className="nav-fill">
                <div id="nav-shop">
                </div>
                <div id="nav-xshop-container">
                  <div id="nav-xshop">
                    <a href="/value-bets" className="nav-a  " tabIndex={47} style={{ color: '#ff9900', fontWeight: 'bold' }}>⚽ Value Bets</a>
                    <a href="/value-bets-predictions" className="nav-a  " tabIndex={48} style={{ color: '#ffcc00', fontWeight: 'bold' }}>💎 Value Predictions</a>
                    <a href="file:///D:/E-Commerce/Frontend/Amazon/www.amazon.com/international-sales-offers/b/index2acf.html?ie=UTF8&node=15529609011&ref_=nav_cs_gb_intl" className="nav-a  " tabIndex={49}>Today's Deals</a>
                    <a href="file:///D:/E-Commerce/Frontend/Amazon/www.amazon.com/gp/help/customer/display27ca.html?nodeId=508510&ref_=nav_cs_customerservice" className="nav-a  " tabIndex={49}>Customer Service</a>
                    <a href="file:///D:/E-Commerce/Frontend/Amazon/www.amazon.com/gift-cards/b/indexb407.html?ie=UTF8&node=2238192011&ref_=nav_cs_gc" className="nav-a  " tabIndex={50}>Gift Cards</a>
                    <a href="file:///D:/E-Commerce/Frontend/Amazon/www.amazon.com/gp/browse9c2e.html?node=16115931011&ref_=nav_cs_registry" className="nav-a  " tabIndex={51}>Registry</a>
                    <a href="file:///D:/E-Commerce/Frontend/Amazon/www.amazon.com/b/indexa5f9.html?_encoding=UTF8&ld=AZUSSOA-sell&node=12766669011&ref_=nav_cs_sell" className="nav-a  " tabIndex={52}>Sell</a>
                    <a href="file:///D:/E-Commerce/Frontend/Amazon/www.amazon.com/ap/signin973a.html" aria-label="Click to call our Disability Customer Support line, or reach us directly at 1-888-283-1678" className="nav-hidden-aria  " tabIndex={53}>Disability Customer Support</a>
                  </div>
                </div>
              </div>
            </div>
            <div id="nav-subnav-toaster" />
            <div id="nav-cover" style={{ zIndex: 1, height: 6723, display: 'none', opacity: '0.6' }} /><div id="nav-cover" style={{ zIndex: 1, height: 6283, display: 'none', opacity: '0.6' }} /></div>

        </div>


      );
    



export default mainNavigation;
