import React from 'react';
import '../../Navigation/Styles.css';
import PredictionItemWithPayment from './EventItem/PredictionItemWithPayment';
import './EventList.css';

const PredictionList = props => {
  const predictions = props.predictions.map(prediction => {
    return (
      <PredictionItemWithPayment
        key={prediction.predictionId}
        predictionId={prediction.predictionId}
        predictionName={prediction.predictionName}
        predictiontype={prediction.predictiontype}
        numGames={prediction.numGames}
        totalOdds={prediction.totalOdds}
        selectedOdds={prediction.selectedOdds || []}
        userId={props.authUserId}
      />
    );
  });

  return (
    <ul className="predictions-list">
      {predictions}
    </ul>
  );
};

export default PredictionList;