import React from 'react';
import '../../Navigation/Styles.css';
import EventItem from './EventItem/predictionItem';
import './EventList.css';


const productList = props => {
  const products = props.products.map(product => {
    return (
      <EventItem
        key={product._id}
        productId={product._id}
        name={product.name}
        price={product.price}
        date={product.date}
        image={product.image}
        category={product.category}
        brand={product.brand}
        userId={props.authUserId}
        creatorId={product.creator._id}
        onDetail={props.onViewDetail}
      />
    );
  });

  return <ul className="product__list" >{products}</ul>
};

export default productList;
