import React from 'react';
// { Component }
import { BrowserRouter, Route, Routes, Navigate } from 'react-router-dom';
// import {  ApolloProvider } from 'react-apollo';
// import { createHttpLink } from 'apollo-link-http';
// , ApolloClient, createNetworkInterface 
import AuthPage from './pages/Auth';
import PaymentPage from './pages/PaymentPage';
import RegisterPage from './pages/Register';
import EventsPage from './pages/Events';
import TodaysGamesPage from './pages/Today_Betlist';
import BetlistPage from './pages/Betlist';
import OppositeBetlistPage from './pages/OppositeBetlist';
import ValueBetsPredictionsList from './pages/ValueBetsPredictionsList';
import MainNavigation from './components/Navigation/NavMain';
import BetlistRepeatedOddsSection from './pages/BetlistRepeatedOddsSection';
// import AuthContext from './context/auth-context';
import Footer from './components/Footer/Footer';
import HomeProducts from './pages/HomeProducts';
// import Cookies from 'js-cookie';
import './App.css';
import ContactUs from './pages/ContactUs';
import ValueBets from './pages/ValueBets';
import ValueBetPredictions from './pages/ValueBetPredictions';
import AdminPage from './pages/AdminPanel';
import LoginPage from './pages/Login';
import ProductsUpload from './pages/ProductsUpload';
import Home from './pages/Home';
import PredictionDetails from './components/PredictionDetails';
import OrdersPage from './pages/Orders';
import AdminOrders from './pages/AdminOrders';
import OrderDetail from './pages/OrderDetail';
import Home105trial from './pages/Home105trial';
import ProfilePage from './pages/Profile';
// import { ApolloClient} from "apollo-client";
import { ApolloProvider, ApolloClient, InMemoryCache, HttpLink } from '@apollo/client';
import { setContext } from '@apollo/client/link/context';
// import { createUploadLink } from "apollo-upload-client";
// import { InMemoryCache } from "apollo-cache-inmemory";
import { CookiesProvider } from 'react-cookie';
// import { ApolloLink } from "apollo-link";



const httpLink = new HttpLink({
  uri: 'http://localhost:5000/api/predictions',
  credentials: 'include',
});

const authLink = setContext((_, { headers }) => {
  const token = localStorage.getItem('token');
  const refreshToken = localStorage.getItem('refreshToken');
  return {
    headers: {
      ...headers,
      'x-token': token ? token : '',
      'x-refresh-token': refreshToken ? refreshToken : '',
    },
  };
});

const client = new ApolloClient({
  link: authLink.concat(httpLink),
  cache: new InMemoryCache(),
});

const App = () => (
      // return (
      
      <BrowserRouter future={{ v7_startTransition: true, v7_relativeSplatPath: true }}>
        <React.Fragment>
        <ApolloProvider client={client}>
          <CookiesProvider
            // value={{
            //   token: this.state.token,
            //   name: this.state.name,
            //   userId: this.state.userId,
            //   login: this.login,
            //   logout: this.logout
            // }}
          >
            <MainNavigation/>
            <main className="main-content">
              <Routes>
                <Route path="/" element={<Navigate to="/login" replace />} />
                {/* <Route path="/login" element={<Navigate to="/productupload" replace />} /> */}
                <Route path="/homeproducts" element={<HomeProducts />} />
                <Route path="/betlist" element={<BetlistPage />} />
                <Route path="/opposite-betlist" element={<OppositeBetlistPage />} />
                <Route path="/value-bets-predictions" element={<ValueBetsPredictionsList />} />
                <Route path="/repeated-odds" element={<BetlistRepeatedOddsSection />} />
                <Route path="/value-bets" element={<ValueBets />} />
                <Route path="/value-bet-predictions" element={<ValueBetPredictions />} />
                <Route path="/events" element={<EventsPage />} />
                <Route path="/contact" element={<ContactUs />} />
                <Route path="/auth" element={<AuthPage />} />
                <Route path="/productupload" element={<ProductsUpload />} />
                <Route path="/home" element={<Home />} />
                <Route path="/home-trial" element={<Home105trial />} />
                <Route path="/login" element={<LoginPage />} />
                <Route path="/profile" element={<ProfilePage />} />
                <Route path="/payment" element={<PaymentPage />} />
                <Route path="/register" element={<RegisterPage />} />
                <Route path="/adminpanel" element={<AdminPage />} />
                <Route path="/todayspredictions" element={<TodaysGamesPage />} />
                <Route path="/prediction-details" element={<PredictionDetails />} />
                <Route path="/orders" element={<OrdersPage />} />
                <Route path="/admin/orders" element={<AdminOrders />} />
                <Route path="/orders/:id" element={<OrderDetail />} />
                {/* {cookies.token && (
                  <Route path="/bookings" element={<BookingsPage />} />
                )} */}
                {/* {!cookies.token && <Navigate to="/login" replace />} */}
              </Routes>
            </main>
            
            <Footer />
          </CookiesProvider>
          </ApolloProvider>
        </React.Fragment>
      </BrowserRouter>
      
    );
//   }
// }
// const networkInterface = createNetworkInterface({
//   uri: 'http://localhost:3080/graphql',
//   opts: {
//     credentials: 'include',
//   },
// });
              
    
export default App;
