const http = require('http');
const urls = ['http://localhost:3000/api/repeated-odds', 'http://localhost:5000/api/repeated-odds'];

(async () => {
  for (const url of urls) {
    try {
      await new Promise((resolve, reject) => {
        const req = http.get(url, (res) => {
          console.log('\nURL:', url);
          console.log('STATUS:', res.statusCode);
          console.log('CT:', res.headers['content-type']);
          let data = '';
          res.on('data', (c) => data += c);
          res.on('end', () => {
            console.log('BODY_SNIPPET:', data.slice(0, 800));
            resolve();
          });
        });
        req.on('error', (e) => {
          console.log('\nURL:', url);
          console.log('ERR:', e.message);
          resolve();
        });
      });
    } catch (e) {
      console.error('FAIL', url, e && e.message);
    }
  }
})();
