# 🚀 Quick Start Testing Guide

## What Was Built

After users complete a payment (M-Pesa or Card), they're automatically redirected to see their invoice. This guide helps you test it!

---

## ⚡ 5-Minute Setup

### Prerequisites
```
✓ Backend running: node app_sortingtype.js
✓ Frontend running: npm start
✓ Both on localhost (backend: 5000, frontend: 3000)
✓ Firebase configured
✓ M-Pesa & Stripe keys set
```

---

## 🧪 Test 1: M-Pesa Payment → Invoice

### Steps
1. Open http://localhost:3000/betlist
2. Click any prediction's "Buy Prediction" button
3. Select **M-Pesa** payment method
4. Enter phone: **254712345678**
5. Click "Pay with M-Pesa"
6. In another terminal, confirm payment by running:
   ```bash
   curl -X POST http://localhost:5000/api/payments/callback \
     -H "Content-Type: application/json" \
     -d '{"CheckoutRequestID":"ws_CO_...","ResultCode":0,"ResultDesc":"success"}'
   ```

### Expected Result
```
✅ Modal shows "Payment completed successfully!"
✅ Automatic redirect happens (1.5 seconds)
✅ Green banner appears: "✓ Payment successful!"
✅ Invoice displays with:
   - Prediction name
   - Amount (KES 100)
   - Date & time
   - Status: Paid ✓
✅ Can download PDF and copy SMS
```

---

## 💳 Test 2: Card Payment → Invoice

### Steps
1. Open http://localhost:3000/betlist
2. Click any prediction's "Buy Prediction" button
3. Select **Card** payment method
4. Enter test card:
   - **Card Number:** 4242 4242 4242 4242
   - **Expiry:** Any future date (e.g., 12/25)
   - **CVC:** Any 3 digits (e.g., 123)
5. Click "Pay with Card"

### Expected Result
```
✅ Stripe processes immediately
✅ Modal shows "Payment completed successfully!"
✅ Automatic redirect happens (1.5 seconds)
✅ Green banner appears: "✓ Payment successful!"
✅ Invoice displays with all payment details
✅ Can download PDF and copy SMS
```

---

## 📊 Test 3: View Historical Invoice

### Steps
1. Open http://localhost:3000/invoices
2. You should see table with past payments
3. Find a **completed** payment (✓ status)
4. Click the **"View"** button

### Expected Result
```
✅ Navigates to prediction-details page
✅ Shows invoice for that payment
✅ Can download PDF
✅ Can copy SMS code
```

---

## ✅ What to Verify

### Success Criteria

**Banner Display**
- [ ] Green banner appears
- [ ] Message reads: "✓ Payment successful!"
- [ ] Appears above invoice section
- [ ] Has green background (#e6ffed)
- [ ] Has green border (#2ecc71)

**Invoice Display**
- [ ] Prediction name shows
- [ ] Amount displays (KES 100)
- [ ] Date and time show
- [ ] Status shows "Paid" with checkmark
- [ ] Invoice ID/Reference shows

**Buttons Work**
- [ ] "Download PDF" downloads file
- [ ] "Copy SMS" copies SMS string
- [ ] PDF is readable
- [ ] SMS can be pasted

**Mobile View**
- [ ] Modal responsive on mobile
- [ ] Invoice responsive on mobile
- [ ] Buttons accessible on mobile
- [ ] Banner readable on mobile

---

## 🔍 Debugging Tips

### If redirect doesn't happen:
```javascript
// Open browser console (F12 → Console)
// Should see:
// ✓ No errors
// ✓ Navigation happens
// ✓ URL changes to /prediction-details

// Check:
1. Is backend running? (http://localhost:5000)
2. Is payment status "completed" in Firebase?
3. Does App.js have /prediction-details route?
```

### If success banner doesn't show:
```javascript
// Check localStorage:
// Open DevTools → Application → Local Storage
// Look for auth token and user data
// Verify user is logged in

// Check:
1. User authenticated?
2. State has fromPayment: true?
3. State has showInvoice: true?
```

### If invoice doesn't display:
```javascript
// Check browser console for errors
// Common issues:
1. Invoice component not rendered
2. Prediction object incomplete
3. Firebase fetch failed
4. useContext(AuthContext) not working

// Solution:
// Check PredictionDetails.js passes prediction to Invoice
```

---

## 📱 Testing Scenarios

### Scenario 1: Fresh Payment
```
New user → Make new payment → Auto redirect
✅ Best case: Payment successful immediately
```

### Scenario 2: Retry Payment
```
Failed payment → Retry button → New attempt → Auto redirect
✅ Second attempt should work
```

### Scenario 3: Timeout Scenario
```
Wait 2+ minutes without payment → Timeout message
✅ Should show "Payment timeout. Please try again"
```

### Scenario 4: Mobile Payment
```
On mobile device → Make payment → See invoice
✅ Should work on 375px width
```

---

## 🎯 Success Indicators

### Firebase Level
```bash
# Check Firebase payment record
# In Firebase Console:
# realtime-db → payments → {reference}
# Should see:
├─ amount: 100
├─ status: "completed"  ← Key indicator
├─ userId: "..."
├─ createdAt: timestamp
└─ checkoutRequestId: "..."
```

### Browser Console
```javascript
// Should see NO errors:
// ✓ Smooth navigation
// ✓ No fetch errors
// ✓ No component warnings
// ✓ Invoice renders

// Bad signs:
// ❌ "Cannot read property 'state'"
// ❌ "useNavigate is not defined"
// ❌ "Firebase permission denied"
```

### Application Behavior
```
✅ Payment Modal closes
✅ Route changes to /prediction-details
✅ Green banner appears (0.2s)
✅ Invoice renders (0.5s)
✅ Buttons are clickable
✅ PDF downloads
✅ SMS copies to clipboard
```

---

## 🐛 Common Issues & Fixes

| Issue | Cause | Fix |
|-------|-------|-----|
| No redirect | Route doesn't exist | Add route to App.js |
| Banner missing | fromPayment: false | Check payment state |
| Invoice empty | Prediction object incomplete | Verify data passed |
| Firebase error | No permissions | Check security rules |
| Stripe error | Keys not loaded | Restart backend |
| M-Pesa timeout | No callback | Simulate callback |

---

## 📊 Test Report Template

```
TEST: M-Pesa Payment Redirect
Date: _____________
Tester: _____________

RESULTS:
✓ Payment modal opened: YES / NO
✓ Phone accepted: YES / NO
✓ Firebase record created: YES / NO
✓ STK initiated: YES / NO
✓ Status updated: YES / NO
✓ Success message shown: YES / NO
✓ Redirect happened: YES / NO
✓ Banner displayed: YES / NO
✓ Invoice rendered: YES / NO
✓ PDF downloadable: YES / NO

ISSUES FOUND:
- [list any issues]

NOTES:
- [any observations]

STATUS: PASS / FAIL
```

---

## 🎬 Step-by-Step Video Script

```
Title: "Invoice Redirect Feature Demo"

[Scene 1: Open prediction page]
"Navigate to the Predict AI betting page"

[Scene 2: Click buy button]
"Click the Buy Prediction button for any match"

[Scene 3: Payment modal]
"Select payment method - M-Pesa or Card"

[Scene 4: Complete payment]
"Enter details and complete the payment"

[Scene 5: Redirect]
"Notice automatic redirect to invoice page"

[Scene 6: Success banner]
"See green success banner at top"

[Scene 7: Invoice display]
"Full invoice with prediction details"

[Scene 8: Download]
"Download or share invoice as PDF"

[End: "Payment to invoice in seconds!"]
```

---

## 📋 Checklist for QA Testing

### Functional Testing
- [ ] M-Pesa payment → redirect works
- [ ] Card payment → redirect works
- [ ] Historical invoice view works
- [ ] Success banner displays
- [ ] Invoice data correct
- [ ] PDF downloads successfully
- [ ] SMS copies to clipboard
- [ ] No console errors

### UI/UX Testing
- [ ] Banner styling correct
- [ ] Invoice layout clean
- [ ] Buttons responsive
- [ ] Text readable
- [ ] Colors correct
- [ ] Animations smooth
- [ ] Load times acceptable

### Browser Testing
- [ ] Chrome works
- [ ] Firefox works
- [ ] Safari works
- [ ] Edge works
- [ ] Mobile browser works

### Device Testing
- [ ] Desktop works
- [ ] Tablet works
- [ ] Mobile works
- [ ] Landscape mode works
- [ ] Portrait mode works

### Error Handling
- [ ] Network error handled
- [ ] Firebase error handled
- [ ] Timeout error handled
- [ ] Invalid data handled
- [ ] Auth error handled

### Security Testing
- [ ] No XSS vulnerabilities
- [ ] No CSRF vulnerabilities
- [ ] No sensitive data exposed
- [ ] URLs don't contain passwords
- [ ] Firebase rules enforced

---

## 🎉 After Testing

### If All Tests Pass ✅
```
1. Mark as READY FOR DEPLOYMENT
2. Notify development team
3. Schedule production deployment
4. Prepare customer communication
5. Monitor first 24 hours
```

### If Issues Found ❌
```
1. Document exact error
2. Check console for stack trace
3. Review related documentation
4. Attempt fix or escalate
5. Re-run test after fix
```

---

## 📞 Support

**Test not working?**

1. Check all prerequisites met
2. Review "Debugging Tips" above
3. Check browser console (F12)
4. Check Firebase console
5. Review relevant documentation

**Still stuck?**

See these guides:
- POST_PAYMENT_REDIRECT_GUIDE.md
- INVOICE_REDIRECT_VISUAL_GUIDE.md
- IMPLEMENTATION_COMPLETE.md

---

## ✨ Summary

```
┌─────────────────────────┐
│ QUICK TEST SUMMARY      │
├─────────────────────────┤
│ Test M-Pesa Payment     │
│ Test Card Payment       │
│ Test Invoice View       │
│ Verify All Features     │
│ Check No Errors         │
│ Confirm Mobile Works    │
│ ✅ READY TO DEPLOY      │
└─────────────────────────┘
```

**Happy Testing! 🚀**
